/*
 * TLC698x.h
 *
 *  Created on: Nov 5, 2021
 *      Author: a0219226
 */

#ifndef TLC6983_H_
#define TLC6983_H_

enum WRITE_COMMAND_ID{
    W_FC0 = 0xAA00,
    W_FC1,
    W_FC2,
    W_FC3,
    W_FC4,
    W_FC5,
    W_FC6,
    W_FC7,
    W_FC8,
    W_FC9,
    W_FC10,
    W_CHIP_INDEX = 0xAA10,
    W_VSYNC = 0XAAF0,
    W_SOFT_RESET = 0XAA80,
    W_SRAM = 0xAA30
};

enum READ_COMMAND_ID{
    R_FC0 = 0xAA60,
    R_FC1,
    R_FC2,
    R_FC3,
    R_FC4,
    R_FC5,
    R_FC6,
    R_FC7,
    R_FC8,
    R_FC9,
    R_FC10,
    R_FC11,
    R_FC12,
    R_FC13,
    R_FC14,
    R_FC15,
    R_CHIP_INDEX = 0xAA70,
};

/* FC0  Bits */
#define MOD_SIZE_0                         (0x000000000000)        /* 2 devices stackable operation */
#define MOD_SIZE_1                         (0x400000000000)        /* 1 device non-stackable operation, SCAN_NUM must <=16 */
#define MOD_SIZE_2                         (0x800000000000)        /* 2 devices stackable operation */
#define MOD_SIZE_3                         (0xC00000000000)        /* 3 devices stackable operation */
#define BACK_TH_0                          (0x000000000000)        /*  */
#define BACK_TH_1                          (0x100000000000)        /*  */
#define BACK_TH_2                          (0x200000000000)        /*  */
#define BACK_TH_3                          (0x300000000000)        /*  */
#define GRP_DLY_B_0                        (0x000000000000)        /* no delay */
#define GRP_DLY_B_1                        (0x020000000000)        /* 1 GCLK */
#define GRP_DLY_B_2                        (0x040000000000)        /* 2 GCLK */
#define GRP_DLY_B_3                        (0x060000000000)        /* 3 GCLK */
#define GRP_DLY_B_4                        (0x080000000000)        /* 4 GCLK */
#define GRP_DLY_B_5                        (0x0A0000000000)        /* 5 GCLK */
#define GRP_DLY_B_6                        (0x0C0000000000)        /* 6 GCLK */
#define GRP_DLY_B_7                        (0x0E0000000000)        /* 7 GCLK */
#define GRP_DLY_G_0                        (0x000000000000)        /* no delay */
#define GRP_DLY_G_1                        (0x004000000000)        /* 1 GCLK */
#define GRP_DLY_G_2                        (0x008000000000)        /* 2 GCLK */
#define GRP_DLY_G_3                        (0x00C000000000)        /* 3 GCLK */
#define GRP_DLY_G_4                        (0x010000000000)        /* 4 GCLK */
#define GRP_DLY_G_5                        (0x014000000000)        /* 5 GCLK */
#define GRP_DLY_G_6                        (0x018000000000)        /* 6 GCLK */
#define GRP_DLY_G_7                        (0x01C000000000)        /* 7 GCLK */
#define GRP_DLY_R_0                        (0x000000000000)        /* no delay */
#define GRP_DLY_R_1                        (0x000800000000)        /* 1 GCLK */
#define GRP_DLY_R_2                        (0x001000000000)        /* 2 GCLK */
#define GRP_DLY_R_3                        (0x001800000000)        /* 3 GCLK */
#define GRP_DLY_R_4                        (0x002000000000)        /* 4 GCLK */
#define GRP_DLY_R_5                        (0x002800000000)        /* 5 GCLK */
#define GRP_DLY_R_6                        (0x003000000000)        /* 6 GCLK */
#define GRP_DLY_R_7                        (0x003800000000)        /* 7 GCLK */
#define LINE_CHRG_0                        (0x000000000000)        /*  */
#define LINE_CHRG_1                        (0x000100000000)        /*  */
#define LINE_CHRG_2                        (0x000200000000)        /*  */
#define LINE_CHRG_3                        (0x000400000000)        /*  */
#define FREQ_MUL_0                         (0x000000000000)        /* 1 x SCLK frequency */
#define FREQ_MUL_1                         (0x000010000000)        /* 2 x SCLK frequency */
#define FREQ_MUL_2                         (0x000020000000)        /* 3 x SCLK frequency */
#define FREQ_MUL_3                         (0x000030000000)        /* 4 x SCLK frequency */
#define FREQ_MUL_4                         (0x000040000000)        /* 5 x SCLK frequency */
#define FREQ_MUL_5                         (0x000050000000)        /* 6 x SCLK frequency */
#define FREQ_MUL_6                         (0x000060000000)        /* 7 x SCLK frequency */
#define FREQ_MUL_7                         (0x000070000000)        /* 8 x SCLK frequency */
#define FREQ_MUL_8                         (0x000080000000)        /* 9 x SCLK frequency */
#define FREQ_MUL_9                         (0x000090000000)        /* 10 x SCLK frequency */
#define FREQ_MUL_10                        (0x0000A0000000)        /* 11 x SCLK frequency */
#define FREQ_MUL_11                        (0x0000B0000000)        /* 12 x SCLK frequency */
#define FREQ_MUL_12                        (0x0000C0000000)        /* 13 x SCLK frequency */
#define FREQ_MUL_13                        (0x0000D0000000)        /* 14 x SCLK frequency */
#define FREQ_MUL_14                        (0x0000E0000000)        /* 15 x SCLK frequency */
#define FREQ_MUL_15                        (0x0000F0000000)        /* 16 x SCLK frequency */
#define FREQ_MUL__1                        (0x000000000000)        /* 1 x SCLK frequency */
#define FREQ_MUL__2                        (0x000010000000)        /* 2 x SCLK frequency */
#define FREQ_MUL__3                        (0x000020000000)        /* 3 x SCLK frequency */
#define FREQ_MUL__4                        (0x000030000000)        /* 4 x SCLK frequency */
#define FREQ_MUL__5                        (0x000040000000)        /* 5 x SCLK frequency */
#define FREQ_MUL__6                        (0x000050000000)        /* 6 x SCLK frequency */
#define FREQ_MUL__7                        (0x000060000000)        /* 7 x SCLK frequency */
#define FREQ_MUL__8                        (0x000070000000)        /* 8 x SCLK frequency */
#define FREQ_MUL__9                        (0x000080000000)        /* 9 x SCLK frequency */
#define FREQ_MUL__10                       (0x000090000000)        /* 10 x SCLK frequency */
#define FREQ_MUL__11                       (0x0000A0000000)        /* 11 x SCLK frequency */
#define FREQ_MUL__12                       (0x0000B0000000)        /* 12 x SCLK frequency */
#define FREQ_MUL__13                       (0x0000C0000000)        /* 13 x SCLK frequency */
#define FREQ_MUL__14                       (0x0000D0000000)        /* 14 x SCLK frequency */
#define FREQ_MUL__15                       (0x0000E0000000)        /* 15 x SCLK frequency */
#define FREQ_MUL__16                       (0x0000F0000000)        /* 16 x SCLK frequency */
#define FREQ_MOD_0                         (0x000000000000)        /* low frequency mode, 40MHz to 80MHz */
#define FREQ_MOD_1                         (0x000008000000)        /* high frequency mode, 80MHz to 160MHz */
#define SUBP_NUM_0                         (0x000000000000)        /* 16 */
#define SUBP_NUM_1                         (0x000000200000)        /* 32 */
#define SUBP_NUM_2                         (0x000000400000)        /* 48 */
#define SUBP_NUM_3                         (0x000000600000)        /* 64 */
#define SUBP_NUM_4                         (0x000000800000)        /* 80 */
#define SUBP_NUM_5                         (0x000000A00000)        /* 96 */
#define SUBP_NUM_6                         (0x000000C00000)        /* 112 */
#define SUBP_NUM_7                         (0x000000E00000)        /* 128 */
#define SUBP_NUM__16                       (0x000000000000)        /* 16 */
#define SUBP_NUM__32                       (0x000000200000)        /* 32 */
#define SUBP_NUM__48                       (0x000000400000)        /* 48 */
#define SUBP_NUM__64                       (0x000000600000)        /* 64 */
#define SUBP_NUM__80                       (0x000000800000)        /* 80 */
#define SUBP_NUM__96                       (0x000000A00000)        /* 96 */
#define SUBP_NUM__112                      (0x000000C00000)        /* 112 */
#define SUBP_NUM__128                      (0x000000E00000)        /* 128 */
#define SCAN_NUM_0                         (0x000000000000)        /* 1 line */
#define SCAN_NUM_1                         (0x000000010000)        /* 2 lines */
#define SCAN_NUM_2                         (0x000000020000)        /* 3 lines */
#define SCAN_NUM_3                         (0x000000030000)        /* 4 lines */
#define SCAN_NUM_4                         (0x000000040000)        /* 5 lines */
#define SCAN_NUM_5                         (0x000000050000)        /* 6 lines */
#define SCAN_NUM_6                         (0x000000060000)        /* 7 lines */
#define SCAN_NUM_7                         (0x000000070000)        /* 8 lines */
#define SCAN_NUM_8                         (0x000000080000)        /* 9 lines */
#define SCAN_NUM_9                         (0x000000090000)        /* 10 lines */
#define SCAN_NUM_10                        (0x0000000A0000)        /* 11 lines */
#define SCAN_NUM_11                        (0x0000000B0000)        /* 12 lines */
#define SCAN_NUM_12                        (0x0000000C0000)        /* 13 lines */
#define SCAN_NUM_13                        (0x0000000D0000)        /* 14 lines */
#define SCAN_NUM_14                        (0x0000000E0000)        /* 15 lines */
#define SCAN_NUM_15                        (0x0000000F0000)        /* 16 lines */
#define SCAN_NUM_16                        (0x000000100000)        /* 17 lines */
#define SCAN_NUM_17                        (0x000000110000)        /* 18 lines */
#define SCAN_NUM_18                        (0x000000120000)        /* 19 lines */
#define SCAN_NUM_19                        (0x000000130000)        /* 20 lines */
#define SCAN_NUM_20                        (0x000000140000)        /* 21 lines */
#define SCAN_NUM_21                        (0x000000150000)        /* 22 lines */
#define SCAN_NUM_22                        (0x000000160000)        /* 23 lines */
#define SCAN_NUM_23                        (0x000000170000)        /* 24 lines */
#define SCAN_NUM_24                        (0x000000180000)        /* 25 lines */
#define SCAN_NUM_25                        (0x000000190000)        /* 26 lines */
#define SCAN_NUM_26                        (0x0000001A0000)        /* 27 lines */
#define SCAN_NUM_27                        (0x0000001B0000)        /* 28 lines */
#define SCAN_NUM_28                        (0x0000001C0000)        /* 29 lines */
#define SCAN_NUM_29                        (0x0000001D0000)        /* 30 lines */
#define SCAN_NUM_30                        (0x0000001E0000)        /* 31 lines */
#define SCAN_NUM_31                        (0x0000001F0000)        /* 32 lines */
#define SCAN_NUM__1                         (0x000000000000)        /* 1 line */
#define SCAN_NUM__2                         (0x000000010000)        /* 2 lines */
#define SCAN_NUM__3                         (0x000000020000)        /* 3 lines */
#define SCAN_NUM__4                         (0x000000030000)        /* 4 lines */
#define SCAN_NUM__5                         (0x000000040000)        /* 5 lines */
#define SCAN_NUM__6                         (0x000000050000)        /* 6 lines */
#define SCAN_NUM__7                         (0x000000060000)        /* 7 lines */
#define SCAN_NUM__8                         (0x000000070000)        /* 8 lines */
#define SCAN_NUM__9                         (0x000000080000)        /* 9 lines */
#define SCAN_NUM__10                         (0x000000090000)        /* 10 lines */
#define SCAN_NUM__11                        (0x0000000A0000)        /* 11 lines */
#define SCAN_NUM__12                        (0x0000000B0000)        /* 12 lines */
#define SCAN_NUM__13                        (0x0000000C0000)        /* 13 lines */
#define SCAN_NUM__14                        (0x0000000D0000)        /* 14 lines */
#define SCAN_NUM__15                        (0x0000000E0000)        /* 15 lines */
#define SCAN_NUM__16                        (0x0000000F0000)        /* 16 lines */
#define SCAN_NUM__17                        (0x000000100000)        /* 17 lines */
#define SCAN_NUM__18                        (0x000000110000)        /* 18 lines */
#define SCAN_NUM__19                        (0x000000120000)        /* 19 lines */
#define SCAN_NUM__20                        (0x000000130000)        /* 20 lines */
#define SCAN_NUM__21                        (0x000000140000)        /* 21 lines */
#define SCAN_NUM__22                        (0x000000150000)        /* 22 lines */
#define SCAN_NUM__23                        (0x000000160000)        /* 23 lines */
#define SCAN_NUM__24                        (0x000000170000)        /* 24 lines */
#define SCAN_NUM__25                        (0x000000180000)        /* 25 lines */
#define SCAN_NUM__26                        (0x000000190000)        /* 26 lines */
#define SCAN_NUM__27                        (0x0000001A0000)        /* 27 lines */
#define SCAN_NUM__28                        (0x0000001B0000)        /* 28 lines */
#define SCAN_NUM__29                        (0x0000001C0000)        /* 29 lines */
#define SCAN_NUM__30                        (0x0000001D0000)        /* 30 lines */
#define SCAN_NUM__31                        (0x0000001E0000)        /* 31 lines */
#define SCAN_NUM__32                        (0x0000001F0000)        /* 32 lines */
#define LODRM_EN_0                         (0x000000000000)        /* disable */
#define LODRM_EN_1                         (0x000000008000)        /* enable */
#define PSP_MOD_0                          (0x000000000000)        /* disable */
#define PSP_MOD_1                          (0x000000002000)        /* save power at high level */
#define PSP_MOD_2                          (0x000000004000)        /* save power at middle level */
#define PSP_MOD_3                          (0x000000006000)        /* save power at low level */
#define PS_EN_0                            (0x000000000000)        /* disable */
#define PS_EN_1                            (0x000000001000)        /* enable */
#define PDC_EN_0                           (0x000000000000)        /* disable */
#define PDC_EN_1                           (0x000000000100)        /* enable */
#define CHIP_NUM_0                         (0x000000000000)        /* 1 device */
#define CHIP_NUM_1                         (0x000000000001)        /* 2 devices */
#define CHIP_NUM_2                         (0x000000000002)        /* 3 devices */
#define CHIP_NUM_3                         (0x000000000003)        /* 4 devices */
#define CHIP_NUM_4                         (0x000000000004)        /* 5 devices */
#define CHIP_NUM_5                         (0x000000000005)        /* 6 devices */
#define CHIP_NUM_6                         (0x000000000006)        /* 7 devices */
#define CHIP_NUM_7                         (0x000000000007)        /* 8 devices */
#define CHIP_NUM_8                         (0x000000000008)        /* 9 devices */
#define CHIP_NUM_9                         (0x000000000009)        /* 10 devices */
#define CHIP_NUM_10                        (0x00000000000A)        /* 11 devices */
#define CHIP_NUM_11                        (0x00000000000B)        /* 12 devices */
#define CHIP_NUM_12                        (0x00000000000C)        /* 13 devices */
#define CHIP_NUM_13                        (0x00000000000D)        /* 14 devices */
#define CHIP_NUM_14                        (0x00000000000E)        /* 15 devices */
#define CHIP_NUM_15                        (0x00000000000F)        /* 16 devices */
#define CHIP_NUM_16                        (0x000000000010)        /* 17 devices */
#define CHIP_NUM_17                        (0x000000000011)        /* 18 devices */
#define CHIP_NUM_18                        (0x000000000012)        /* 19 devices */
#define CHIP_NUM_19                        (0x000000000013)        /* 20 devices */
#define CHIP_NUM_20                        (0x000000000014)        /* 21 devices */
#define CHIP_NUM_21                        (0x000000000015)        /* 22 devices */
#define CHIP_NUM_22                        (0x000000000016)        /* 23 devices */
#define CHIP_NUM_23                        (0x000000000017)        /* 24 devices */
#define CHIP_NUM_24                        (0x000000000018)        /* 25 devices */
#define CHIP_NUM_25                        (0x000000000019)        /* 26 devices */
#define CHIP_NUM_26                        (0x00000000001A)        /* 27 devices */
#define CHIP_NUM_27                        (0x00000000001B)        /* 28 devices */
#define CHIP_NUM_28                        (0x00000000001C)        /* 29 devices */
#define CHIP_NUM_29                        (0x00000000001D)        /* 30 devices */
#define CHIP_NUM_30                        (0x00000000001E)        /* 31 devices */
#define CHIP_NUM_31                        (0x00000000001F)        /* 32 devices */
#define CHIP_NUM__1                         (0x000000000000)        /* 1 device */
#define CHIP_NUM__2                         (0x000000000001)        /* 2 devices */
#define CHIP_NUM__3                         (0x000000000002)        /* 3 devices */
#define CHIP_NUM__4                         (0x000000000003)        /* 4 devices */
#define CHIP_NUM__5                         (0x000000000004)        /* 5 devices */
#define CHIP_NUM__6                         (0x000000000005)        /* 6 devices */
#define CHIP_NUM__7                         (0x000000000006)        /* 7 devices */
#define CHIP_NUM__8                         (0x000000000007)        /* 8 devices */
#define CHIP_NUM__9                         (0x000000000008)        /* 9 devices */
#define CHIP_NUM__10                         (0x000000000009)        /* 10 devices */
#define CHIP_NUM__11                        (0x00000000000A)        /* 11 devices */
#define CHIP_NUM__12                        (0x00000000000B)        /* 12 devices */
#define CHIP_NUM__13                        (0x00000000000C)        /* 13 devices */
#define CHIP_NUM__14                        (0x00000000000D)        /* 14 devices */
#define CHIP_NUM__15                        (0x00000000000E)        /* 15 devices */
#define CHIP_NUM__16                        (0x00000000000F)        /* 16 devices */
#define CHIP_NUM__17                        (0x000000000010)        /* 17 devices */
#define CHIP_NUM__18                        (0x000000000011)        /* 18 devices */
#define CHIP_NUM__19                        (0x000000000012)        /* 19 devices */
#define CHIP_NUM__20                        (0x000000000013)        /* 20 devices */
#define CHIP_NUM__21                        (0x000000000014)        /* 21 devices */
#define CHIP_NUM__22                        (0x000000000015)        /* 22 devices */
#define CHIP_NUM__23                        (0x000000000016)        /* 23 devices */
#define CHIP_NUM__24                        (0x000000000017)        /* 24 devices */
#define CHIP_NUM__25                        (0x000000000018)        /* 25 devices */
#define CHIP_NUM__26                        (0x000000000019)        /* 26 devices */
#define CHIP_NUM__27                        (0x00000000001A)        /* 27 devices */
#define CHIP_NUM__28                        (0x00000000001B)        /* 28 devices */
#define CHIP_NUM__29                        (0x00000000001C)        /* 29 devices */
#define CHIP_NUM__30                        (0x00000000001D)        /* 30 devices */
#define CHIP_NUM__31                        (0x00000000001E)        /* 31 devices */
#define CHIP_NUM__32                        (0x00000000001F)        /* 32 devices */

#endif /* TLC6983_H_ */
